/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWGuid;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.workflow.VWBaseFieldTableModel;
import filenet.vw.toolkit.design.property.workflow.VWTableItemWrapper;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.table.VWFieldDataForTable;
import java.util.Vector;
import javax.swing.Icon;

public class VWGuidFieldTableModel
extends VWBaseFieldTableModel
implements IVWPropertyChangeListener {
    private static final int NUM_COLUMNS = 6;
    public static final int COL_SOURCE = 0;
    public static final int COL_NAME = 1;
    public static final int COL_ARRAY = 2;
    public static final int COL_REQUIRED_CLASS = 3;
    public static final int COL_VALUE = 4;
    public static final int COL_DESCRIPTION = 5;
    private boolean m_bDummyIsArray = false;
    private VWGuid m_dummyRequiredClass = null;
    private Object m_dummyValue = null;
    private String m_dummyDescription = null;

    public VWGuidFieldTableModel(VWAuthPropertyData authPropertyData) {
        super(authPropertyData);
        try {
            this.m_dummyRequiredClass = new VWGuid();
            this.m_dummyValue = new VWGuid();
            this.m_authPropertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void copyItem(int nRowIndex) {
        block4: {
            try {
                VWFieldDefinition fieldDef;
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null && wrapper.getValue() != null && (fieldDef = (VWFieldDefinition)wrapper.getValue()) != null && this.m_authPropertyData != null && this.m_authPropertyData.getWorkflowDefinition() != null) {
                    String copyOfString = VWResource.s_copyOfFieldName.toString(fieldDef.getName());
                    VWFieldDefinition newFieldDef = this.m_authPropertyData.getWorkflowDefinition().createFieldUsingObject(copyOfString, fieldDef.getValue());
                    if (newFieldDef != null) {
                        newFieldDef.setMergeType(fieldDef.getMergeType());
                        newFieldDef.setRequiredClass(fieldDef.getRequiredClass());
                        newFieldDef.setDescription(fieldDef.getDescription());
                        this.m_authPropertyData.resetFieldCache();
                        this.m_authPropertyData.setDirty();
                        this.m_rowData.addElement(new VWTableItemWrapper(0, newFieldDef));
                        nRowIndex = this.getRowCount() - 2;
                        this.fireTableRowsInserted(nRowIndex, nRowIndex);
                        this.m_changedItems = new Vector();
                        this.m_changedItems.addElement(newFieldDef);
                        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 506);
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block4;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    public void deleteItem(int nRowIndex) {
        block6: {
            try {
                VWFieldDefinition fieldDef;
                if (!this.canDeleteRow(nRowIndex)) {
                    return;
                }
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null && wrapper.canDelete() && (fieldDef = (VWFieldDefinition)wrapper.getValue()) != null) {
                    this.m_authPropertyData.getWorkflowDefinition().deleteField(fieldDef.getName());
                    this.m_authPropertyData.resetFieldCache();
                    this.m_authPropertyData.setDirty();
                    if (wrapper.isOverridden()) {
                        wrapper.deleteOverriddenValue();
                        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    } else {
                        this.m_rowData.removeElementAt(nRowIndex);
                        this.fireTableRowsDeleted(nRowIndex, nRowIndex);
                        this.m_changedItems = new Vector();
                        this.m_changedItems.addElement(fieldDef);
                        this.onRemovedFields(this.m_changedItems);
                        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 508);
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block6;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    public void reinitialize() {
        try {
            super.reinitialize();
            if (this.m_authPropertyData != null) {
                int i;
                VWFieldDefinition[] fieldDefs;
                if (this.m_authPropertyData.getShowInheritedProperties() && (fieldDefs = this.m_authPropertyData.getFields(2)) != null) {
                    for (i = 0; i < fieldDefs.length; ++i) {
                        if (fieldDefs[i].getFieldType() != 512) continue;
                        this.m_rowData.addElement(new VWTableItemWrapper(1, fieldDefs[i]));
                    }
                }
                if ((fieldDefs = this.m_authPropertyData.getFields(1)) != null) {
                    for (i = 0; i < fieldDefs.length; ++i) {
                        if (fieldDefs[i].getFieldType() != 512) continue;
                        int nIndex = this.findIndex(fieldDefs[i].getName());
                        if (nIndex != -1) {
                            this.overrideTableItem(nIndex, fieldDefs[i]);
                            continue;
                        }
                        this.m_rowData.addElement(new VWTableItemWrapper(0, fieldDefs[i]));
                    }
                }
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 0: {
                return Icon.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Boolean.class;
            }
            case 3: {
                return VWGuid.class;
            }
            case 4: {
                return Object.class;
            }
            case 5: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 6 - this.m_nColumnIndexOffset;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 1: {
                return VWResource.s_nameStr;
            }
            case 2: {
                return VWResource.s_array;
            }
            case 3: {
                return VWResource.s_requiredClass;
            }
            case 4: {
                return VWResource.s_value;
            }
            case 5: {
                return VWResource.s_descriptionStr;
            }
        }
        return null;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWFieldDefinition fieldDef = null;
            VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
            if (wrapper != null && wrapper.getValue() != null) {
                fieldDef = (VWFieldDefinition)wrapper.getValue();
            }
            switch (nColumnIndex + this.m_nColumnIndexOffset) {
                case 0: {
                    if (wrapper == null) break;
                    return wrapper.getStateIcon();
                }
                case 1: {
                    if (fieldDef != null) {
                        return fieldDef.getName();
                    }
                    return "";
                }
                case 2: {
                    if (fieldDef != null) {
                        return fieldDef.isArray();
                    }
                    return this.m_bDummyIsArray;
                }
                case 3: {
                    if (fieldDef != null) {
                        return new VWFieldDataForTable(512, false, fieldDef.getRequiredClass(), fieldDef.getName());
                    }
                    return new VWFieldDataForTable(512, false, this.m_dummyRequiredClass, "");
                }
                case 4: {
                    if (fieldDef != null) {
                        return new VWFieldDataForTable(fieldDef.getFieldType(), fieldDef.isArray(), fieldDef.getValue(), fieldDef.getName());
                    }
                    return new VWFieldDataForTable(512, this.m_bDummyIsArray, this.m_dummyValue, "");
                }
                case 5: {
                    if (fieldDef != null) {
                        return fieldDef.getDescription();
                    }
                    return this.m_dummyDescription;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 1: 
            case 2: {
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null) {
                    return wrapper.isLocal();
                }
                return true;
            }
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            if (!this.isCellEditable(nRowIndex, nColumnIndex)) {
                return;
            }
            switch (nColumnIndex + this.m_nColumnIndexOffset) {
                case 1: {
                    this.onUpdateFieldName(aValue, nRowIndex);
                    break;
                }
                case 2: {
                    this.onUpdateIsArray(aValue, nRowIndex);
                    break;
                }
                case 3: {
                    this.onUpdateRequiredClass(aValue, nRowIndex);
                    break;
                }
                case 4: {
                    this.onUpdateFieldValue(aValue, nRowIndex);
                    break;
                }
                case 5: {
                    this.onUpdateDescription(aValue, nRowIndex);
                    break;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        switch (event.getID()) {
            case 580: {
                if (event.getSource() == this) break;
                this.reinitialize();
            }
        }
    }

    private void onUpdateFieldName(Object aValue, int nRowIndex) {
        block17: {
            VWFieldDefinition fieldDef = null;
            try {
                if (aValue == null || !(aValue instanceof String)) {
                    return;
                }
                String newName = (String)aValue;
                if (newName.length() == 0) {
                    return;
                }
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null && wrapper.getValue() != null) {
                    fieldDef = (VWFieldDefinition)wrapper.getValue();
                }
                if (fieldDef != null) {
                    if (VWStringUtils.compare(newName, fieldDef.getName()) == 0) {
                        return;
                    }
                    String[] names = new String[]{fieldDef.getName(), newName};
                    fieldDef.setName(names[1]);
                    this.m_authPropertyData.setDirty();
                    this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    this.m_changedItems = new Vector();
                    this.m_changedItems.addElement(names[0]);
                    this.m_changedItems.addElement(names[1]);
                    this.onRenamedField(this.m_changedItems);
                    this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 509);
                } else if (this.m_authPropertyData != null && this.m_authPropertyData.getWorkflowDefinition() != null) {
                    if (this.m_authPropertyData.getField(newName) != null) {
                        String message = VWResource.s_fieldExists.toString(newName);
                        VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), message, 1);
                        return;
                    }
                    if (this.m_bDummyIsArray) {
                        if (this.m_dummyValue == null || !(this.m_dummyValue instanceof VWGuid[])) {
                            this.m_dummyValue = new VWGuid[0];
                        }
                    } else if (this.m_dummyValue == null || !(this.m_dummyValue instanceof VWGuid)) {
                        this.m_dummyValue = new VWGuid();
                    }
                    if ((fieldDef = this.m_authPropertyData.getWorkflowDefinition().createFieldUsingObject(newName, this.m_dummyValue)) != null) {
                        if (fieldDef.isArray()) {
                            fieldDef.setMergeType(6);
                        } else {
                            fieldDef.setMergeType(3);
                        }
                        fieldDef.setRequiredClass(this.m_dummyRequiredClass);
                        fieldDef.setDescription(this.m_dummyDescription);
                        this.m_authPropertyData.resetFieldCache();
                        this.m_authPropertyData.setDirty();
                        this.m_dummyRequiredClass = new VWGuid();
                        this.m_dummyValue = this.m_bDummyIsArray ? new VWGuid[0] : new VWGuid();
                        this.m_dummyDescription = null;
                        this.m_rowData.addElement(new VWTableItemWrapper(0, fieldDef));
                        this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
                        this.m_changedItems = new Vector();
                        this.m_changedItems.addElement(fieldDef);
                        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 506);
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block17;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    private void onUpdateIsArray(Object aValue, int nRowIndex) {
        try {
            if (aValue == null) {
                return;
            }
            boolean bIsArray = (Boolean)aValue;
            VWFieldDefinition fieldDef = null;
            VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
            if (wrapper != null && wrapper.getValue() != null) {
                fieldDef = (VWFieldDefinition)wrapper.getValue();
            }
            if (fieldDef != null) {
                fieldDef.setValue(this.getNewFieldValue(bIsArray, fieldDef.getValue()));
                if (fieldDef.isArray()) {
                    fieldDef.setMergeType(6);
                } else {
                    fieldDef.setMergeType(3);
                }
                this.m_authPropertyData.setDirty();
                this.m_changedItems = new Vector();
                this.m_changedItems.addElement(fieldDef);
                this.onChangedField(fieldDef);
                this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 507);
            } else {
                this.m_bDummyIsArray = bIsArray;
                this.m_dummyValue = this.getNewFieldValue(this.m_bDummyIsArray, this.m_dummyValue);
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUpdateRequiredClass(Object aValue, int nRowIndex) {
        block10: {
            VWFieldDefinition fieldDef = null;
            try {
                VWTableItemWrapper wrapper;
                if (aValue == null) {
                    return;
                }
                if ((aValue = this.getNewFieldValue(false, aValue)) instanceof String && ((String)aValue).length() == 0) {
                    aValue = null;
                }
                if ((wrapper = this.getTableItemAt(nRowIndex)) != null && wrapper.getValue() != null) {
                    fieldDef = (VWFieldDefinition)wrapper.getValue();
                }
                if (fieldDef != null) {
                    if (wrapper.isInherited()) {
                        VWGuid currentRequiredClass = fieldDef.getRequiredClass();
                        if (currentRequiredClass == null || !currentRequiredClass.equals(aValue)) {
                            int nMergeType = fieldDef.getMergeType();
                            Object newFieldValue = this.getNewFieldValue(fieldDef.isArray(), fieldDef.getValue());
                            String description = fieldDef.getDescription();
                            fieldDef = this.m_authPropertyData.getWorkflowDefinition().createFieldUsingObject(fieldDef.getName(), newFieldValue);
                            fieldDef.setMergeType(nMergeType);
                            fieldDef.setRequiredClass((VWGuid)aValue);
                            fieldDef.setDescription(description);
                            wrapper.overrideValue(fieldDef);
                        }
                    } else {
                        fieldDef.setRequiredClass((VWGuid)aValue);
                    }
                    this.m_authPropertyData.setDirty();
                    this.m_changedItems = new Vector();
                    this.m_changedItems.addElement(fieldDef);
                    this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 581);
                } else {
                    this.m_dummyRequiredClass = (VWGuid)aValue;
                }
                this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block10;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    private void onUpdateFieldValue(Object aValue, int nRowIndex) {
        VWFieldDefinition fieldDef = null;
        try {
            VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
            if (wrapper != null && wrapper.getValue() != null) {
                fieldDef = (VWFieldDefinition)wrapper.getValue();
            }
            if (fieldDef != null) {
                Object newFieldValue = this.getNewFieldValue(fieldDef.isArray(), aValue);
                if (wrapper.isInherited()) {
                    int nMergeType = fieldDef.getMergeType();
                    VWGuid requiredClass = fieldDef.getRequiredClass();
                    String description = fieldDef.getDescription();
                    fieldDef = this.m_authPropertyData.getWorkflowDefinition().createFieldUsingObject(fieldDef.getName(), newFieldValue);
                    fieldDef.setMergeType(nMergeType);
                    fieldDef.setRequiredClass(requiredClass);
                    fieldDef.setDescription(description);
                    wrapper.overrideValue(fieldDef);
                } else {
                    fieldDef.setValue(newFieldValue);
                }
                this.m_authPropertyData.setDirty();
                this.m_changedItems = new Vector();
                this.m_changedItems.addElement(fieldDef);
                this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 507);
            } else {
                this.m_dummyValue = this.getNewFieldValue(this.m_bDummyIsArray, aValue);
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUpdateDescription(Object aValue, int nRowIndex) {
        VWFieldDefinition fieldDef = null;
        try {
            if (aValue == null) {
                return;
            }
            VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
            if (wrapper != null && wrapper.getValue() != null) {
                fieldDef = (VWFieldDefinition)wrapper.getValue();
            }
            if (fieldDef != null) {
                if (wrapper.isInherited()) {
                    String currentDesc = fieldDef.getDescription();
                    if (currentDesc == null || VWStringUtils.compare(aValue.toString(), currentDesc) != 0) {
                        int nMergeType = fieldDef.getMergeType();
                        VWGuid requiredClass = fieldDef.getRequiredClass();
                        Object newFieldValue = this.getNewFieldValue(fieldDef.isArray(), fieldDef.getValue());
                        fieldDef = this.m_authPropertyData.getWorkflowDefinition().createFieldUsingObject(fieldDef.getName(), newFieldValue);
                        fieldDef.setMergeType(nMergeType);
                        fieldDef.setRequiredClass(requiredClass);
                        fieldDef.setDescription(aValue.toString());
                        wrapper.overrideValue(fieldDef);
                    }
                } else {
                    fieldDef.setDescription(aValue.toString());
                }
                this.m_authPropertyData.setDirty();
                this.m_changedItems = new Vector();
                this.m_changedItems.addElement(fieldDef);
                this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 507);
            } else {
                this.m_dummyDescription = aValue.toString();
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private Object getNewFieldValue(boolean bIsArray, Object oldValue) throws VWException {
        if (bIsArray) {
            VWGuid[] values;
            if (oldValue != null && oldValue instanceof VWGuid[] && (values = (VWGuid[])oldValue).length > 0) {
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] != null) continue;
                    values[i] = new VWGuid();
                }
                return values;
            }
            VWGuid[] array = new VWGuid[]{oldValue != null && oldValue instanceof VWGuid ? (VWGuid)oldValue : new VWGuid()};
            return array;
        }
        if (oldValue != null && oldValue instanceof VWGuid[] && ((Object[])oldValue).length > 0) {
            return ((VWGuid[])oldValue)[0];
        }
        if (oldValue != null && oldValue instanceof VWGuid) {
            return (VWGuid)oldValue;
        }
        return new VWGuid();
    }
}

